import os
import requests
from urllib.parse import urlparse

# === CSV failu URL saraksts ===
csv_urls = [
    "https://data.gov.lv/dati/dataset/8d31b878-536a-44aa-a013-8bc6b669d477/resource/27fcc5ec-c63b-4bfd-bb08-01f073a52d04/download/financial_statements.csv",
    "https://data.gov.lv/dati/dataset/8d31b878-536a-44aa-a013-8bc6b669d477/resource/50ef4f26-f410-4007-b296-22043ca3dc43/download/balance_sheets.csv",
    "https://data.gov.lv/dati/dataset/8d31b878-536a-44aa-a013-8bc6b669d477/resource/d5fd17ef-d32e-40cb-8399-82b780095af0/download/income_statements.csv",
    "https://data.gov.lv/dati/dataset/4de9697f-850b-45ec-8bba-61fa09ce932f/resource/25e80bf3-f107-4ab4-89ef-251b5b9374e9/download/register.csv",
    "https://data.gov.lv/dati/dataset/5ed74664-b49d-4b28-aacb-040931646e9b/resource/a42d6e8c-1768-4939-ba9b-7700d4f1dd3a/download/pdb_nm_komersantu_samaksato_nodoklu_kopsumas_odata.csv"
]

# === Galvenā funkcija ===
def download_csv_files(urls):
    """
    Lejupielādē CSV failus no norādītajiem URL direktorijā 'csv'.
    """
    # 1. Fiksēts direktorijas nosaukums
    dir_name = "csv"

    # 2. Izveido direktoriju (ja tāda vēl neeksistē)
    try:
        os.makedirs(dir_name, exist_ok=True)
        print(f"Direktorija '{dir_name}' izveidota vai jau eksistē.")
    except OSError as e:
        print(f"Kļūda veidojot direktoriju '{dir_name}': {e}")
        return

    # 3. Iterē cauri katram URL un lejupielādē failu
    download_count = 0
    error_count = 0
    skipped_count = 0

    # Noņemam dublikātus no URL saraksta, saglabājot secību
    unique_urls = []
    seen_urls = set()
    for url in urls:
        if url not in seen_urls:
            unique_urls.append(url)
            seen_urls.add(url)

    for url in unique_urls:
        try:
            # Iegūst faila nosaukumu no URL
            parsed_url = urlparse(url)
            filename = os.path.basename(parsed_url.path)

            # Pārbauda, vai tas ir CSV fails
            if not filename.lower().endswith('.csv'):
                 print(f"Brīdinājums: URL '{url}' neizskatās pēc CSV faila, tiek izlaists.")
                 skipped_count += 1
                 continue

            # Izveido pilno ceļu, kur saglabāt failu (mapē 'csv')
            file_path = os.path.join(dir_name, filename)

            print(f"Lejupielādē: {filename}...")

            # Veic HTTP GET pieprasījumu
            response = requests.get(url, stream=True, timeout=60)
            response.raise_for_status()

            # Saglabā faila saturu
            with open(file_path, 'wb') as f:
                for chunk in response.iter_content(chunk_size=8192):
                    f.write(chunk)

            print(f"Veiksmīgi saglabāts: {file_path}")
            download_count += 1

        except requests.exceptions.RequestException as e:
            print(f"Kļūda lejupielādējot {url}: {e}")
            error_count += 1
        except OSError as e:
            print(f"Kļūda saglabājot failu {filename} direktorijā '{dir_name}': {e}")
            error_count += 1
        except Exception as e:
            print(f"Nezināma kļūda apstrādājot {url}: {e}")
            error_count += 1

    # Paziņo par rezultātu
    print("\n--- Lejupielādes kopsavilkums ---")
    print(f"Direktorija: {dir_name}")
    print(f"Veiksmīgi lejupielādēti faili: {download_count}")
    print(f"Izlaisti (nav .csv): {skipped_count}")
    print(f"Faili ar kļūdām: {error_count}")
    print("---------------------------------")

# === Skripta izpilde ===
if __name__ == "__main__":
    download_csv_files(csv_urls)